require 'page-object'

class Modal
  include PageObject

  h3(:modalTitle, :css => '.modal-header h3')
  div(:content, :css => '.modal-body')
  div(:modalDialog, :css =>'.modal-dialog')

  button(:modalOkbut, :css =>'#description-ok-btn')
  button(:ok, :css => 'button[data-ng-click="modalContent.ok();"]')
  button(:return, :css => 'button[data-ng-click="modalContent.close();"]')
  button(:delete, :css =>'#delete-question-delete-btn')
  button(:cancel, :css => '#delete-question-cancel-btn')
  button(:ok_button, :css => 'button[data-ng-click="modalContent.ok();"]')

  buttons(:buttons, :css=>'.modal-dialog .modal-footer button')

  #VHA external site definitions
  #site-title
  h1(:vha_site_title, :id => 'site-title')

  def isModalPopUpPresent()
    begin
      return modalDialog_element.exists?
    rescue Exception=>e
      return false
    end
  end
end

